#ifndef __maindefs_h
#define __maindefs_h

#include <p18f26j11.h>
#include <stdio.h>

//#define _DEBUG
#define _BASE_STATION
//#define _REMOTE

#ifdef _BASE_STATION
#define BASE_STATION_ADDRESS 1
#define _SPI2_V2
#endif
#ifdef _REMOTE
#define _SPI2_V1
#endif

// Enable or disable debug prints depending on project preprocessor (_DEBUG)
#ifdef _DEBUG
#define DBG_PRINT_MAIN(x) printf(x)
#define DBG_PRINT_I2C(x)
#define DBG_PRINT_XBEE(x)
#define DBG_PRINT_PORTB_INT(x)
#define DBG_PRINT_INT(x)
#define DBG_PRINT_BUFFER(x) printf(x)
#else
#define DBG_PRINT_MAIN(x)
#define DBG_PRINT_I2C(x)
#define DBG_PRINT_XBEE(x)
#define DBG_PRINT_PORTB_INT(x)
#define DBG_PRINT_INT(x)
#define DBG_PRINT_BUFFER(x)
#endif

#define RETURNID_ACC    10
#define RETURNID_GYRO   11
#define RETURNID_CONN   12
#define RETURNID_BTN1   13
#define RETURNID_BTN2   14
#define RETURNID_NEW_REMOTE_SRC 15
#define RETURNID_NEW_REMOTE_CON 16
#define RETURNID_DATA_FIN   17

// Message type definitions
#define MSGTYPE_RESEND 1

#define MSGTYPE_TIMER0      10
#define MSGTYPE_TIMER1      11
#define MSGTYPE_TIMER2      12
#define MSGTYPE_TIMER3      13
#define MSGTYPE_TIMER4      14
#define MSGTYPE_TIMER5      15
#define MSGTYPE_TIMER6      16
#define MSGTYPE_TIMER8      17
#define MSGTYPE_MAIN1       20
#define	MSGTYPE_OVERRUN     30
#define MSGTYPE_UART_DATA   31
#define MSGTYPE_I2C_DBG     40
#define	MSGTYPE_I2C_DATA    41
#define MSGTYPE_I2C_REPLY   42
//#define MSGTYPE_I2C_RQST 43

// Unused (Used for I2C Master Mode)
#define MSGTYPE_I2C_MASTER_SEND_COMPLETE    43
#define MSGTYPE_I2C_MASTER_SEND_FAILED      44
#define MSGTYPE_I2C_MASTER_RECV_COMPLETE    45
#define MSGTYPE_I2C_MASTER_RECV_FAILED      46

#define MSGTYPE_ADC_NEWVALUE 50

#define MSGTYPE_XBEE_RX_AT_COMMAND_RESPONSE         60
#define MSGTYPE_XBEE_RX_DATA_PACKET                 61
#define MSGTYPE_XBEE_RX_DATA_TX_STATUS              62
#define MSGTYPE_XBEE_RX_IO_DATA_SAMPLE              63
#define MSGTYPE_XBEE_RX_EXPLICIT_COMMAND            64
#define MSGTYPE_XBEE_RX_REMOTE_AT_COMMAND_RESPONSE  65
#define MSGTYPE_XBEE_RX_ROUTE_RECORD                66
#define MSGTYPE_XBEE_RX_NODE_IDENTIFICATION         67
#define MSGTYPE_XBEE_RX_FRAME_MODEM_STATUS          68

#define MSGTYPE_PORTB_4_DOWN    70
#define MSGTYPE_PORTB_4_UP      71
#define MSGTYPE_PORTB_5_DOWN    72
#define MSGTYPE_PORTB_5_UP      73
#define MSGTYPE_PORTB_6_DOWN    74
#define MSGTYPE_PORTB_6_UP      75
#define MSGTYPE_PORTB_7_DOWN    76
#define MSGTYPE_PORTB_7_UP      77

#define MSGTYPE_INT1    80

enum I2C_STATE {
    I2C_STATE_IDLE,
    I2C_STATE_READ_ACC,
    I2C_STATE_READ_GYRO
};

enum XBEE_STATE {
    XBEE_STATE_WAITING_TO_JOIN,
    XBEE_STATE_JOINED_NETWORK,
    XBEE_STATE_QUERY_PARENT
};

#endif

